/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor.json.jsonpath.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.jmeter.extractor.json.jsonpath.JSONPostProcessor;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.processor.gui.AbstractPostProcessorGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;

@GUIMenuSortOrder(value=2)
@TestElementMetadata(labelResource="json_post_processor_title")
public class JSONPostProcessorGui
extends AbstractPostProcessorGui {
    private static final long serialVersionUID = -2845056031828291476L;
    private JLabeledTextField defaultValuesField;
    private JLabeledTextField jsonPathExpressionsField;
    private JLabeledTextField refNamesField;
    private JLabeledTextField matchNumbersField;
    private JCheckBox computeConcatenationField;

    public JSONPostProcessorGui() {
        this.init();
    }

    public String getLabelResource() {
        return "json_post_processor_title";
    }

    public void configure(TestElement element) {
        super.configure(element);
        JSONPostProcessor config = (JSONPostProcessor)element;
        this.showScopeSettings(config, true);
        this.refNamesField.setText(config.getRefNames());
        this.jsonPathExpressionsField.setText(config.getJsonPathExpressions());
        this.matchNumbersField.setText(config.getMatchNumbers());
        this.defaultValuesField.setText(config.getDefaultValues());
        this.computeConcatenationField.setSelected(config.getComputeConcatenation());
    }

    public TestElement createTestElement() {
        JSONPostProcessor config = new JSONPostProcessor();
        this.modifyTestElement((TestElement)config);
        return config;
    }

    public void modifyTestElement(TestElement c) {
        super.configureTestElement(c);
        if (c instanceof JSONPostProcessor) {
            JSONPostProcessor config = (JSONPostProcessor)c;
            this.saveScopeSettings(config);
            config.setRefNames(this.refNamesField.getText());
            config.setJsonPathExpressions(this.jsonPathExpressionsField.getText());
            config.setDefaultValues(this.defaultValuesField.getText());
            config.setMatchNumbers(this.matchNumbersField.getText());
            config.setComputeConcatenation(this.computeConcatenationField.isSelected());
        }
    }

    public void clearGui() {
        super.clearGui();
        this.refNamesField.setText("");
        this.jsonPathExpressionsField.setText("");
        this.matchNumbersField.setText("");
        this.defaultValuesField.setText("");
        this.computeConcatenationField.setSelected(false);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        Box box = Box.createVerticalBox();
        box.add(this.makeTitlePanel());
        box.add(this.createScopePanel(true));
        this.add(box, "North");
        this.add(this.makeParameterPanel(), "Center");
    }

    private JPanel makeParameterPanel() {
        this.refNamesField = new JLabeledTextField(JMeterUtils.getResString((String)"jsonpp_variable_names"));
        this.jsonPathExpressionsField = new JLabeledTextField(JMeterUtils.getResString((String)"jsonpp_json_path_expressions"));
        this.matchNumbersField = new JLabeledTextField(JMeterUtils.getResString((String)"jsonpp_match_numbers"));
        this.defaultValuesField = new JLabeledTextField(JMeterUtils.getResString((String)"jsonpp_default_values"));
        this.computeConcatenationField = new JCheckBox();
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.initConstraints(gbc);
        this.addField(panel, this.refNamesField, gbc);
        this.nextLine(gbc);
        this.addField(panel, this.jsonPathExpressionsField, gbc);
        this.nextLine(gbc);
        this.addField(panel, this.matchNumbersField, gbc);
        this.nextLine(gbc);
        this.addField(panel, new JLabel(JMeterUtils.getResString((String)"jsonpp_compute_concat")), this.computeConcatenationField, gbc);
        this.nextLine(gbc);
        gbc.weighty = 1.0;
        this.addField(panel, this.defaultValuesField, gbc);
        return panel;
    }

    private void addField(JPanel panel, JLabeledTextField field, GridBagConstraints gbc) {
        List item = field.getComponentList();
        panel.add((Component)item.get(0), gbc.clone());
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)item.get(1), gbc.clone());
    }

    private void addField(JPanel panel, JLabel label, JCheckBox checkBox, GridBagConstraints gbc) {
        panel.add((Component)label, gbc.clone());
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)checkBox, gbc.clone());
    }

    private void nextLine(GridBagConstraints gbc) {
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.fill = 0;
    }

    private void initConstraints(GridBagConstraints gbc) {
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
    }
}

