/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.resource.inmemory;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.io.ByteArrayWrapper;
import com.helger.commons.io.IHasByteArray;
import com.helger.commons.io.resource.inmemory.AbstractMemoryReadableResource;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.InputStream;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReadableResourceByteArray
extends AbstractMemoryReadableResource
implements IHasByteArray {
    public static final boolean DEFAULT_COPY_NEEDED = true;
    private final ByteArrayWrapper m_aBytes;

    public ReadableResourceByteArray(@Nonnull byte[] byArray) {
        this(null, byArray, true);
    }

    public ReadableResourceByteArray(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        this(null, byArray, n, n2, true);
    }

    public ReadableResourceByteArray(@Nonnull byte[] byArray, boolean bl) {
        this((String)null, byArray, bl);
    }

    public ReadableResourceByteArray(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, boolean bl) {
        this(null, byArray, n, n2, bl);
    }

    public ReadableResourceByteArray(@Nullable String string, @Nonnull byte[] byArray) {
        this(string, byArray, true);
    }

    public ReadableResourceByteArray(@Nullable String string, @Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        this(string, byArray, n, n2, true);
    }

    public ReadableResourceByteArray(@Nullable String string, @Nonnull byte[] byArray, boolean bl) {
        this(string, byArray, 0, byArray.length, bl);
    }

    public ReadableResourceByteArray(@Nullable String string, @Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, boolean bl) {
        super(StringHelper.hasText(string) ? string : "bytes-" + n2 + "-" + Arrays.hashCode(byArray));
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        this.m_aBytes = new ByteArrayWrapper(byArray, n, n2, bl);
    }

    @Override
    public final boolean isCopy() {
        return this.m_aBytes.isCopy();
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final byte[] bytes() {
        return this.m_aBytes.bytes();
    }

    @Override
    @Nonnegative
    public int getOffset() {
        return this.m_aBytes.getOffset();
    }

    @Override
    @Nonnegative
    public final int size() {
        return this.m_aBytes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_aBytes.isEmpty();
    }

    @Override
    @Nonnull
    public InputStream getInputStream() {
        return this.m_aBytes.getInputStream();
    }

    @Override
    public boolean isReadMultiple() {
        return this.m_aBytes.isReadMultiple();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("Bytes", this.m_aBytes).getToString();
    }
}

