/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.relative;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.file.FileOperationManager;
import com.helger.commons.io.file.FileSystemRecursiveIterator;
import com.helger.commons.io.relative.IFileRelativeIO;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.timing.StopWatch;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class FileRelativeIO
implements IFileRelativeIO {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileRelativeIO.class);
    private final File m_aBasePath;

    public static void internalCheckAccessRights(@Nonnull File file) {
        StopWatch stopWatch = StopWatch.createdStarted();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Checking file access in " + file);
        }
        int n = 0;
        int n2 = 0;
        for (File file2 : new FileSystemRecursiveIterator(file)) {
            if (file2.isFile()) {
                if (!file2.canRead()) {
                    throw new IllegalArgumentException("Cannot read file " + file2);
                }
                if (!file2.canWrite() && LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Cannot write file " + file2);
                }
                ++n;
                continue;
            }
            if (file2.isDirectory()) {
                if (!file2.canRead()) {
                    throw new IllegalArgumentException("Cannot read in directory " + file2);
                }
                if (!file2.canWrite() && LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Cannot write in directory " + file2);
                }
                if (!file2.canExecute() && LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Cannot execute in directory " + file2);
                }
                ++n2;
                continue;
            }
            if (!LOGGER.isWarnEnabled()) continue;
            LOGGER.warn("Neither file nor directory: " + file2);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Finished checking file access for " + n + " files and " + n2 + " directories in " + stopWatch.stopAndGetMillis() + " milliseconds");
        }
    }

    public FileRelativeIO(@Nonnull File file) {
        ValueEnforcer.notNull(file, "BasePath");
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("Please provide an absolute path: " + file);
        }
        FileOperationManager.INSTANCE.createDirRecursiveIfNotExisting(file);
        if (!file.isDirectory()) {
            throw new InitializationException("The passed base path " + file + " exists but is not a directory!");
        }
        try {
            this.m_aBasePath = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    @Nonnull
    public File getBasePathFile() {
        return this.m_aBasePath;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FileRelativeIO fileRelativeIO = (FileRelativeIO)object;
        return this.m_aBasePath.equals(fileRelativeIO.m_aBasePath);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aBasePath).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("BasePath", this.m_aBasePath).getToString();
    }

    @Nonnull
    public static FileRelativeIO createForCurrentDir() {
        return new FileRelativeIO(new File(".").getAbsoluteFile());
    }
}

