/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.StatContext;
import jetbrains.datalore.plot.base.data.TransformVar;
import jetbrains.datalore.plot.base.stat.BaseStat;
import jetbrains.datalore.plot.base.stat.BinStatUtil;
import jetbrains.datalore.plot.base.stat.Stats;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0002 !B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ;\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u0012H\u0016J.\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u001dH\u0002J\u0012\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0\u001dH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ljetbrains/datalore/plot/base/stat/BinStat;", "Ljetbrains/datalore/plot/base/stat/BaseStat;", "binCount", "", "binWidth", "", "xPosKind", "Ljetbrains/datalore/plot/base/stat/BinStat$XPosKind;", "xPos", "(ILjava/lang/Double;Ljetbrains/datalore/plot/base/stat/BinStat$XPosKind;D)V", "binOptions", "Ljetbrains/datalore/plot/base/stat/BinStatUtil$BinOptions;", "apply", "Ljetbrains/datalore/plot/base/DataFrame;", "data", "statCtx", "Ljetbrains/datalore/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "computeStatSeries", "Ljetbrains/datalore/plot/base/stat/BinStatUtil$BinsData;", "rangeX", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "valuesX", "", "consumes", "Ljetbrains/datalore/plot/base/Aes;", "Companion", "XPosKind", "plot-base-portable"})
public final class BinStat
extends BaseStat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XPosKind xPosKind;
    private final double xPos;
    @NotNull
    private final BinStatUtil.BinOptions binOptions;
    public static final int DEF_BIN_COUNT = 30;
    @NotNull
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;

    public BinStat(int binCount, @Nullable Double binWidth, @NotNull XPosKind xPosKind, double xPos) {
        Intrinsics.checkNotNullParameter((Object)((Object)xPosKind), (String)"xPosKind");
        super(DEF_MAPPING);
        this.xPosKind = xPosKind;
        this.xPos = xPos;
        this.binOptions = new BinStatUtil.BinOptions(binCount, binWidth);
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        Object[] objectArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getWEIGHT()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        Aes[] aesArray = new Aes[]{Aes.Companion.getX()};
        if (!this.hasRequiredValues(data, aesArray)) {
            return this.withEmptyStatValues();
        }
        ArrayList statX = new ArrayList();
        ArrayList statCount = new ArrayList();
        ArrayList statDensity = new ArrayList();
        ClosedRange<Double> rangeX = statCtx.overallXRange();
        if (rangeX != null) {
            BinStatUtil.BinsData binsData = this.computeStatSeries(data, rangeX, data.getNumeric(TransformVar.INSTANCE.getX()));
            statX.addAll(binsData.getX$plot_base_portable());
            statCount.addAll(binsData.getCount$plot_base_portable());
            statDensity.addAll(binsData.getDensity$plot_base_portable());
        }
        return new DataFrame.Builder().putNumeric(Stats.INSTANCE.getX(), statX).putNumeric(Stats.INSTANCE.getCOUNT(), statCount).putNumeric(Stats.INSTANCE.getDENSITY(), statDensity).build();
    }

    private final BinStatUtil.BinsData computeStatSeries(DataFrame data, ClosedRange<Double> rangeX, List<Double> valuesX) {
        double normalBinWidth;
        Double startX = rangeX.getLowerEnd();
        double d = ((Number)rangeX.getUpperEnd()).doubleValue();
        Double d2 = startX;
        Intrinsics.checkNotNull((Object)d2);
        double spanX = d - d2;
        BinStatUtil.CountAndWidth b = BinStatUtil.INSTANCE.binCountAndWidth(spanX, this.binOptions);
        startX = startX - b.getWidth() * 0.7;
        spanX += b.getWidth() * 1.4;
        b = BinStatUtil.INSTANCE.binCountAndWidth(spanX, this.binOptions);
        int binCount = b.getCount();
        double binWidth = b.getWidth();
        if (this.xPosKind != XPosKind.NONE) {
            double minDelta = Double.MAX_VALUE;
            double x2 = this.xPos;
            int n = 0;
            if (n < binCount) {
                do {
                    int i = n++;
                    double binLeft = startX + (double)i * binWidth;
                    double delta = 0.0;
                    if (this.xPosKind == XPosKind.CENTER) {
                        delta = x2 - (binLeft + binWidth / (double)2);
                    } else {
                        if (i == 0) {
                            minDelta = x2 - startX;
                        }
                        delta = x2 - (binLeft + binWidth);
                    }
                    boolean bl = false;
                    bl = false;
                    if (!(Math.abs(delta) < Math.abs(minDelta))) continue;
                    minDelta = delta;
                } while (n < binCount);
            }
            double offset2 = minDelta % (binWidth / (double)2);
            startX = startX + offset2;
        }
        double densityNormalizingFactor = (normalBinWidth = SeriesUtil.INSTANCE.span(rangeX) / (double)binCount) > 0.0 ? 1.0 / normalBinWidth : 1.0;
        BinStatUtil.BinsData binsData = BinStatUtil.INSTANCE.computeBins(valuesX, startX, binCount, binWidth, BinStatUtil.INSTANCE.weightAtIndex(data), densityNormalizingFactor);
        boolean bl = binsData.getX$plot_base_portable().size() == binCount;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Internal: stat data size=" + binsData.getX$plot_base_portable().size() + " expected bin count=" + binCount;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return binsData;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getCOUNT())};
        DEF_MAPPING = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/plot/base/stat/BinStat$XPosKind;", "", "(Ljava/lang/String;I)V", "NONE", "CENTER", "BOUNDARY", "plot-base-portable"})
    public static final class XPosKind
    extends Enum<XPosKind> {
        public static final /* enum */ XPosKind NONE = new XPosKind();
        public static final /* enum */ XPosKind CENTER = new XPosKind();
        public static final /* enum */ XPosKind BOUNDARY = new XPosKind();
        private static final /* synthetic */ XPosKind[] $VALUES;

        public static XPosKind[] values() {
            return (XPosKind[])$VALUES.clone();
        }

        public static XPosKind valueOf(String value) {
            return Enum.valueOf(XPosKind.class, value);
        }

        static {
            $VALUES = xPosKindArray = new XPosKind[]{XPosKind.NONE, XPosKind.CENTER, XPosKind.BOUNDARY};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/base/stat/BinStat$Companion;", "", "()V", "DEF_BIN_COUNT", "", "DEF_MAPPING", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

