/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.json;

import java.util.Map;
import jetbrains.datalore.base.json.JsonLexer;
import jetbrains.datalore.base.json.JsonSupportKt;
import jetbrains.datalore.base.json.Token;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\n\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0013\u001a\u00020\u00122\n\u0010\u0014\u001a\u00020\u0015\"\u00020\u00062\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017H\u0002J\u001c\u0010\u0018\u001a\u00020\u00122\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0006\u0010\u001c\u001a\u00020\u001bJ\u0006\u0010\u001d\u001a\u00020\u0012J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\b\u0010 \u001a\u00020\u001bH\u0002J\b\u0010!\u001a\u00020\u0012H\u0002J\b\u0010\"\u001a\u00020\u0012H\u0002J\u0006\u0010#\u001a\u00020\u0003R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ljetbrains/datalore/base/json/JsonLexer;", "", "input", "", "(Ljava/lang/String;)V", "currentChar", "", "getCurrentChar", "()C", "<set-?>", "Ljetbrains/datalore/base/json/Token;", "currentToken", "getCurrentToken", "()Ljetbrains/datalore/base/json/Token;", "i", "", "tokenStart", "advance", "", "advanceIfCurrent", "expected", "", "then", "Lkotlin/Function0;", "advanceWhile", "pred", "Lkotlin/Function1;", "", "isFinished", "nextToken", "read", "str", "readNumber", "readString", "startToken", "tokenValue", "Companion", "base-portable"})
public final class JsonLexer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String input;
    private int i;
    private int tokenStart;
    @Nullable
    private Token currentToken;
    @NotNull
    private static final CharRange digits = new CharRange('0', '9');

    public JsonLexer(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
        this.nextToken();
    }

    @Nullable
    public final Token getCurrentToken() {
        return this.currentToken;
    }

    private final char getCurrentChar() {
        return this.input.charAt(this.i);
    }

    public final void nextToken() {
        Token token;
        Token it;
        boolean bl;
        boolean bl2;
        Token token2;
        this.advanceWhile((Function1<? super Character, Boolean>)((Function1)nextToken.1.INSTANCE));
        if (this.isFinished()) {
            return;
        }
        if (this.getCurrentChar() == '{') {
            token2 = Token.LEFT_BRACE;
            bl2 = false;
            bl = false;
            it = token2;
            boolean bl3 = false;
            this.advance();
            token = token2;
        } else if (this.getCurrentChar() == '}') {
            token2 = Token.RIGHT_BRACE;
            bl2 = false;
            bl = false;
            it = token2;
            boolean bl4 = false;
            this.advance();
            token = token2;
        } else if (this.getCurrentChar() == '[') {
            token2 = Token.LEFT_BRACKET;
            bl2 = false;
            bl = false;
            it = token2;
            boolean bl5 = false;
            this.advance();
            token = token2;
        } else if (this.getCurrentChar() == ']') {
            token2 = Token.RIGHT_BRACKET;
            bl2 = false;
            bl = false;
            it = token2;
            boolean bl6 = false;
            this.advance();
            token = token2;
        } else if (this.getCurrentChar() == ',') {
            token2 = Token.COMMA;
            bl2 = false;
            bl = false;
            it = token2;
            boolean bl7 = false;
            this.advance();
            token = token2;
        } else if (this.getCurrentChar() == ':') {
            token2 = Token.COLON;
            bl2 = false;
            bl = false;
            it = token2;
            boolean bl8 = false;
            this.advance();
            token = token2;
        } else if (this.getCurrentChar() == 't') {
            token2 = Token.TRUE;
            bl2 = false;
            bl = false;
            it = token2;
            boolean bl9 = false;
            this.read("true");
            token = token2;
        } else if (this.getCurrentChar() == 'f') {
            token2 = Token.FALSE;
            bl2 = false;
            bl = false;
            it = token2;
            boolean bl10 = false;
            this.read("false");
            token = token2;
        } else if (this.getCurrentChar() == 'n') {
            token2 = Token.NULL;
            bl2 = false;
            bl = false;
            it = token2;
            boolean bl11 = false;
            this.read("null");
            token = token2;
        } else if (this.getCurrentChar() == '\"') {
            token2 = Token.STRING;
            bl2 = false;
            bl = false;
            it = token2;
            boolean bl12 = false;
            this.readString();
            token = token2;
        } else if (this.readNumber()) {
            token = Token.NUMBER;
        } else {
            String string = "" + this.i + ':' + this.getCurrentChar() + " - unkown token";
            boolean bl13 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        token2 = token;
        bl2 = false;
        bl = false;
        it = token2;
        boolean bl14 = false;
        this.currentToken = it;
    }

    @NotNull
    public final String tokenValue() {
        String string = this.input;
        int n = this.tokenStart;
        int n2 = this.i;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    private final void readString() {
        this.startToken();
        this.advance();
        while (this.getCurrentChar() != '\"') {
            if (this.getCurrentChar() == '\\') {
                int n;
                this.advance();
                if (this.getCurrentChar() == 'u') {
                    this.advance();
                    int n2 = 4;
                    boolean bl = false;
                    n = 0;
                    n = 0;
                    int n3 = n2;
                    while (n < n3) {
                        int it = n++;
                        boolean bl2 = false;
                        boolean bl3 = JsonLexer.Companion.isHex(this.getCurrentChar());
                        boolean bl4 = false;
                        boolean bl5 = false;
                        bl5 = false;
                        boolean bl6 = false;
                        if (!bl3) {
                            boolean bl7 = false;
                            String string = "Failed requirement.";
                            throw (Throwable)new IllegalArgumentException(string.toString());
                        }
                        this.advance();
                    }
                    continue;
                }
                Object object = JsonSupportKt.getSPECIAL_CHARS();
                Character c = Character.valueOf(this.getCurrentChar());
                n = 0;
                Map<Character, Character> map = object;
                boolean bl = false;
                if (map.containsKey(c)) {
                    this.advance();
                    continue;
                }
                object = "Invalid escape sequence";
                boolean bl8 = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            this.advance();
        }
        this.advance();
    }

    private final boolean readNumber() {
        if (!JsonLexer.Companion.isDigit(Character.valueOf(this.getCurrentChar())) && this.getCurrentChar() != '-') {
            return false;
        }
        this.startToken();
        char[] cArray = new char[]{'-'};
        JsonLexer.advanceIfCurrent$default(this, cArray, null, 2, null);
        this.advanceWhile((Function1<? super Character, Boolean>)((Function1)readNumber.1.INSTANCE));
        cArray = new char[]{'.'};
        this.advanceIfCurrent(cArray, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ JsonLexer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                boolean bl = jetbrains.datalore.base.json.JsonLexer$Companion.access$isDigit(JsonLexer.Companion, Character.valueOf(JsonLexer.access$getCurrentChar(this.this$0)));
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "Number should have decimal part";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                JsonLexer.access$advanceWhile(this.this$0, readNumber.2.INSTANCE);
            }
        }));
        cArray = new char[]{'e', 'E'};
        this.advanceIfCurrent(cArray, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ JsonLexer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                char[] cArray = new char[]{'+', '-'};
                JsonLexer.advanceIfCurrent$default(this.this$0, cArray, null, 2, null);
                JsonLexer.access$advanceWhile(this.this$0, readNumber.1.INSTANCE);
            }
        }));
        return true;
    }

    public final boolean isFinished() {
        return this.i == this.input.length();
    }

    private final void startToken() {
        this.tokenStart = this.i;
    }

    private final void advance() {
        JsonLexer jsonLexer = this;
        ++jsonLexer.i;
        int cfr_ignored_0 = jsonLexer.i;
    }

    private final void read(String str) {
        CharSequence $this$forEach$iv = str;
        boolean $i$f$forEach = false;
        CharSequence charSequence = $this$forEach$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            char element$iv;
            char it = element$iv = charSequence.charAt(i);
            boolean bl = false;
            boolean bl2 = this.getCurrentChar() == it;
            boolean bl3 = false;
            boolean bl4 = false;
            if (!bl2) {
                boolean bl5 = false;
                String string = Intrinsics.stringPlus((String)"Wrong data: ", (Object)str);
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl2 = !this.isFinished();
            bl3 = false;
            bl4 = false;
            if (!bl2) {
                boolean bl6 = false;
                String string = "Unexpected end of string";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            this.advance();
        }
    }

    private final void advanceWhile(Function1<? super Character, Boolean> pred) {
        while (!this.isFinished() && ((Boolean)pred.invoke((Object)Character.valueOf(this.getCurrentChar()))).booleanValue()) {
            this.advance();
        }
    }

    private final void advanceIfCurrent(char[] expected, Function0<Unit> then) {
        if (!this.isFinished() && ArraysKt.contains((char[])expected, (char)this.getCurrentChar())) {
            this.advance();
            then.invoke();
        }
    }

    static /* synthetic */ void advanceIfCurrent$default(JsonLexer jsonLexer, char[] cArray, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = advanceIfCurrent.1.INSTANCE;
        }
        jsonLexer.advanceIfCurrent(cArray, (Function0<Unit>)function0);
    }

    public static final /* synthetic */ char access$getCurrentChar(JsonLexer $this) {
        return $this.getCurrentChar();
    }

    public static final /* synthetic */ void access$advanceWhile(JsonLexer $this, Function1 pred) {
        $this.advanceWhile((Function1<? super Character, Boolean>)pred);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\f\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0005\u001a\u00020\u0006*\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010\bJ\f\u0010\t\u001a\u00020\u0006*\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ljetbrains/datalore/base/json/JsonLexer$Companion;", "", "()V", "digits", "Lkotlin/ranges/CharRange;", "isDigit", "", "", "(Ljava/lang/Character;)Z", "isHex", "base-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isDigit(Character $this$isDigit) {
            CharRange charRange = digits;
            boolean bl = false;
            return $this$isDigit != null && charRange.contains($this$isDigit.charValue());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isHex(char $this$isHex) {
            boolean bl;
            if (this.isDigit(Character.valueOf($this$isHex))) return true;
            if ('a' <= $this$isHex) {
                if ($this$isHex <= 'f') {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if ('A' > $this$isHex) return false;
            if ($this$isHex > 'F') return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

