/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.controller;

import com.blazemeter.jmeter.controller.ParallelSampler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.control.gui.LogicControllerGui;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.testelement.TestElement;

public class ParallelControllerGui
extends LogicControllerGui {
    private static final String MSG = "All direct child elements of this controller will be executed as parallel.";
    public static final String WIKIPAGE = "https://github.com/Blazemeter/jmeter-bzm-plugins/tree/master/jmeter-parallel-http/Parallel.md#parallel-controller";
    private JCheckBox generateParentSamples;
    private JCheckBox limitMaxThreadNumber;
    private JSpinner maxThreadNumber;
    private SpinnerNumberModel model;

    public ParallelControllerGui() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel((Container)this.makeTitlePanel(), (String)WIKIPAGE), "North");
        Container topPanel = this.makeTitlePanel();
        this.add(topPanel, "North");
        HorizontalPanel parentSamplePanel = new HorizontalPanel();
        JLabel lbl = new JLabel(MSG, 0);
        topPanel.add(lbl);
        this.generateParentSamples = new JCheckBox();
        parentSamplePanel.add(this.generateParentSamples);
        parentSamplePanel.add(new JLabel("Generate parent sample", 4));
        HorizontalPanel limitPanel = new HorizontalPanel();
        this.limitMaxThreadNumber = new JCheckBox();
        limitPanel.add(this.limitMaxThreadNumber);
        limitPanel.add(new JLabel("Limit max thread number", 4));
        this.limitMaxThreadNumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParallelControllerGui.this.maxThreadNumber.setEnabled(ParallelControllerGui.this.limitMaxThreadNumber.isSelected());
            }
        });
        HorizontalPanel threadsPanel = new HorizontalPanel();
        this.model = new SpinnerNumberModel(6, 1, 10, 1);
        this.maxThreadNumber = new JSpinner(this.model);
        this.maxThreadNumber.setEnabled(false);
        threadsPanel.add(new JLabel("Max threads: ", 4));
        threadsPanel.add(this.maxThreadNumber);
        HorizontalPanel limitThreadsWrap = new HorizontalPanel();
        limitThreadsWrap.add((Component)limitPanel);
        limitThreadsWrap.add((Component)threadsPanel);
        topPanel.add((Component)parentSamplePanel);
        topPanel.add((Component)limitThreadsWrap);
    }

    public String getStaticLabel() {
        return "bzm - Parallel Controller";
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public TestElement createTestElement() {
        ParallelSampler te = new ParallelSampler();
        this.modifyTestElement((TestElement)te);
        return te;
    }

    public void modifyTestElement(TestElement te) {
        super.configureTestElement(te);
        if (te instanceof ParallelSampler) {
            ParallelSampler parallelSampler = (ParallelSampler)te;
            parallelSampler.setMaxThreadNumber(this.model.getNumber().intValue());
            parallelSampler.setGenerateParent(this.generateParentSamples.isSelected());
            parallelSampler.setLimitMaxThreadNumber(this.limitMaxThreadNumber.isSelected());
        }
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof ParallelSampler) {
            this.model.setValue(((ParallelSampler)element).getMaxThreadNumber());
            this.generateParentSamples.setSelected(((ParallelSampler)element).getGenerateParent());
            this.limitMaxThreadNumber.setSelected(((ParallelSampler)element).getLimitMaxThreadNumber());
            this.maxThreadNumber.setEnabled(this.limitMaxThreadNumber.isSelected());
        }
    }
}

