/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository.util;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JTextField;

public class PlaceholderTextField
extends JTextField {
    private String placeholder;

    @Override
    protected void paintComponent(Graphics pG) {
        super.paintComponent(pG);
        if (this.placeholder.length() == 0 || this.getText().length() > 0) {
            return;
        }
        Graphics2D g = (Graphics2D)pG;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.getDisabledTextColor());
        g.drawString(this.placeholder, this.getInsets().left, pG.getFontMetrics().getMaxAscent() + this.getInsets().top);
    }

    public void setPlaceholder(String s) {
        this.placeholder = s;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }
}

