/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang3.StringUtils;
import org.jmeterplugins.repository.CheckBoxList;
import org.jmeterplugins.repository.GenericCallback;
import org.jmeterplugins.repository.Plugin;
import org.jmeterplugins.repository.PluginCheckbox;
import org.jmeterplugins.repository.PluginManagerDialog;
import org.jmeterplugins.repository.util.PlaceholderTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginsList
extends JPanel
implements ListSelectionListener,
HyperlinkListener {
    private static final long serialVersionUID = 295116233618658217L;
    private static final Logger log = LoggerFactory.getLogger(PluginsList.class);
    private final JTextPane description = new JTextPane();
    protected final PlaceholderTextField searchField = new PlaceholderTextField();
    private final DefaultListModel<PluginCheckbox> searchResults = new DefaultListModel();
    protected JList<PluginCheckbox> list = new CheckBoxList<PluginCheckbox>(5);
    private DefaultListModel<PluginCheckbox> listModel = new DefaultListModel();
    protected final JComboBox<String> version = new JComboBox();
    private ItemListener itemListener = new VerChoiceChanged();
    private GenericCallback<Object> dialogRefresh;

    public PluginsList(GenericCallback<Object> dialogRefresh) {
        super(new BorderLayout(5, 0));
        this.dialogRefresh = dialogRefresh;
        this.description.setContentType("text/html");
        this.description.setEditable(false);
        this.description.addHyperlinkListener(this);
        this.list.setModel(this.listModel);
        this.list.setBorder(PluginManagerDialog.SPACING);
        this.list.addListSelectionListener(this);
        this.add(this.getPluginsListComponent(), "West");
        this.add((Component)this.getDetailsPanel(), "Center");
        this.list.setComponentPopupMenu(new ToggleAllPopupMenu());
    }

    private Component getPluginsListComponent() {
        this.initSearchField();
        JPanel topAndDown = new JPanel(new BorderLayout(5, 0));
        topAndDown.add((Component)this.searchField, "North");
        topAndDown.add(new JScrollPane(this.list));
        return topAndDown;
    }

    private void initSearchField() {
        this.searchField.setPlaceholder("Search...");
        this.searchField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                PluginsList.this.filterPluginsList();
            }
        });
    }

    private void filterPluginsList() {
        String filter = this.searchField.getText().toLowerCase();
        if (!filter.isEmpty()) {
            this.searchResults.clear();
            for (int i = 0; i < this.listModel.size(); ++i) {
                PluginCheckbox pluginCheckbox = this.listModel.getElementAt(i);
                Plugin plugin = pluginCheckbox.getPlugin();
                String data = plugin.getSearchIndexString();
                if (!data.contains(filter)) continue;
                this.searchResults.addElement(pluginCheckbox);
            }
            this.list.setModel(this.searchResults);
        } else {
            this.list.setModel(this.listModel);
        }
    }

    public void setPlugins(Set<Plugin> plugins, ChangeListener checkboxNotifier) {
        this.listModel.clear();
        for (Plugin plugin : plugins) {
            this.listModel.addElement(this.getCheckboxItem(plugin, checkboxNotifier));
        }
    }

    private JPanel getDetailsPanel() {
        JPanel detailsPanel = new JPanel(new BorderLayout());
        detailsPanel.add((Component)new JScrollPane(this.description), "Center");
        this.version.setEnabled(false);
        JPanel verPanel = new JPanel(new BorderLayout());
        verPanel.add((Component)new JLabel("Version: "), "West");
        verPanel.add(this.version, "Center");
        detailsPanel.add((Component)verPanel, "South");
        return detailsPanel;
    }

    protected PluginCheckbox getCheckboxItem(Plugin plugin, ChangeListener changeNotifier) {
        PluginCheckbox element = new PluginCheckbox(plugin.getName());
        element.setSelected(plugin.isInstalled());
        element.setPlugin(plugin);
        element.addChangeListener(changeNotifier);
        return element;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && this.list.getSelectedIndex() >= 0) {
            Plugin plugin = this.list.getSelectedValue().getPlugin();
            this.description.setText(this.getDescriptionHTML(plugin));
            this.setUpVersionsList(this.list.getSelectedValue());
            this.setToolTipRenderer(plugin);
            this.cacheImage(plugin);
            this.description.setCaretPosition(0);
        }
    }

    private void setToolTipRenderer(Plugin plugin) {
        ArrayList<String> tooltips = new ArrayList<String>();
        for (String version : plugin.getVersions()) {
            tooltips.add(plugin.getVersionChanges(version));
        }
        this.version.setRenderer(new ComboboxToolTipRenderer(tooltips));
    }

    protected void setUpVersionsList(PluginCheckbox cb) {
        this.version.removeItemListener(this.itemListener);
        this.version.removeAllItems();
        for (String ver : cb.getPlugin().getVersions()) {
            this.version.addItem(ver);
        }
        this.version.setSelectedItem(this.getCbVersion(cb));
        this.version.setEnabled(this.version.getItemCount() > 1);
        this.version.addItemListener(this.itemListener);
    }

    protected String getCbVersion(PluginCheckbox cb) {
        Plugin plugin = cb.getPlugin();
        if (plugin.isInstalled()) {
            return plugin.getInstalledVersion();
        }
        return plugin.getCandidateVersion();
    }

    String getDescriptionHTML(Plugin plugin) {
        Map<String, String> libs;
        Set<String> deps;
        String changes;
        String txt = "<h1>" + plugin.getName() + "</h1>";
        if (plugin.isUpgradable()) {
            txt = txt + "<p><font color='orange'>This plugin can be upgraded to version " + plugin.getMaxVersion() + "</font></p>";
        }
        if (!plugin.getVendor().isEmpty()) {
            txt = txt + "<p>Vendor: <i>" + plugin.getVendor() + "</i></p>";
        }
        if (!plugin.getDescription().isEmpty()) {
            txt = txt + "<p>" + plugin.getDescription() + "</p>";
        }
        if (!plugin.getHelpLink().isEmpty()) {
            txt = txt + "<p>Documentation: <a href='" + plugin.getHelpLink() + "'>" + plugin.getHelpLink() + "</a></p>";
        }
        if (null != (changes = plugin.getVersionChanges(plugin.getCandidateVersion()))) {
            txt = txt + "<p>What's new in version " + plugin.getCandidateVersion() + ": " + changes + "</p>";
        }
        txt = txt + this.getMavenInfo(plugin);
        if (!plugin.getScreenshot().isEmpty()) {
            txt = txt + "<p><img src='" + plugin.getScreenshot() + "'/></p>";
        }
        if (plugin.getInstalledPath() != null) {
            txt = txt + "<pre>Location: " + plugin.getInstalledPath() + "</pre>";
        }
        if (!(deps = plugin.getDepends()).isEmpty()) {
            txt = txt + "<pre>Dependencies: " + Arrays.toString(deps.toArray(new String[0])) + "</pre>";
        }
        if (!(libs = plugin.getLibs(plugin.getCandidateVersion())).isEmpty()) {
            txt = txt + "<pre>Libraries: " + Arrays.toString(libs.keySet().toArray(new String[0])) + "</pre>";
        }
        return txt + "<br/>";
    }

    private String getMavenInfo(Plugin plugin) {
        String downloadUrl;
        int indexOfFP;
        String txt = "";
        if (plugin.getCandidateVersion() != null && (indexOfFP = (downloadUrl = plugin.getDownloadUrl(plugin.getCandidateVersion())).indexOf("filepath=")) > 0) {
            String artifactUrl = downloadUrl.substring(indexOfFP + "filepath=".length());
            String[] parts = artifactUrl.split("/");
            String lastVersionId = parts[parts.length - 2];
            String artifactId = parts[parts.length - 3];
            StringBuilder groupId = new StringBuilder();
            for (int i = 0; i < parts.length - 3; ++i) {
                groupId.append(parts[i]).append(".");
            }
            if (!StringUtils.isEmpty((CharSequence)groupId)) {
                txt = txt + "<p>Maven groupId: <i>" + groupId.substring(0, groupId.length() - 1) + "</i>, artifactId: <i>" + artifactId + "</i>, version: <i>" + lastVersionId + "</i></p>";
            }
        }
        return txt;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            PluginsList.openInBrowser(e.getURL().toString());
        }
    }

    public static void openInBrowser(String string) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI(string));
            }
            catch (IOException | URISyntaxException ignored) {
                log.debug("Failed to open in browser", (Throwable)ignored);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.list.setEnabled(enabled);
        this.version.setEnabled(enabled);
        for (PluginCheckbox ch : Collections.list(this.listModel.elements())) {
            ch.setEnabled(enabled);
        }
    }

    private void cacheImage(Plugin plugin) {
        if (!plugin.getScreenshot().isEmpty()) {
            try {
                URL url;
                BufferedImage image;
                Hashtable<URL, BufferedImage> cache = (Hashtable<URL, BufferedImage>)this.description.getDocument().getProperty("imageCache");
                if (cache == null) {
                    cache = new Hashtable<URL, BufferedImage>();
                    this.description.getDocument().putProperty("imageCache", cache);
                }
                if ((image = ImageIO.read(url = new URL(plugin.getScreenshot()))) != null) {
                    ((Dictionary)cache).put(url, image);
                }
            }
            catch (IOException e) {
                log.warn("Cannot cached image " + plugin.getScreenshot());
            }
        }
    }

    private class ComboboxToolTipRenderer
    extends DefaultListCellRenderer {
        private final List<String> tooltips;

        public ComboboxToolTipRenderer(List<String> tooltips) {
            this.tooltips = tooltips;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent comp = (JComponent)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (-1 < index && null != value && null != this.tooltips && this.tooltips.size() > index) {
                list.setToolTipText(this.tooltips.get(index));
            }
            return comp;
        }
    }

    private class ToggleAllPopupMenu
    extends JPopupMenu
    implements ActionListener {
        private static final long serialVersionUID = -4299203920659842279L;

        public ToggleAllPopupMenu() {
            super("Toggle All");
            JMenuItem menuItem = new JMenuItem("Toggle All");
            menuItem.addActionListener(this);
            this.add(menuItem);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (Object a : PluginsList.this.listModel.toArray()) {
                if (!(a instanceof PluginCheckbox)) continue;
                PluginCheckbox cb = (PluginCheckbox)a;
                cb.doClick();
            }
            PluginsList.this.list.repaint();
        }
    }

    private class VerChoiceChanged
    implements ItemListener {
        private VerChoiceChanged() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1 && event.getItem() instanceof String) {
                String item = (String)event.getItem();
                Plugin plugin = PluginsList.this.list.getSelectedValue().getPlugin();
                plugin.setCandidateVersion(item);
                PluginsList.this.dialogRefresh.notify(this);
                PluginsList.this.description.setText(PluginsList.this.getDescriptionHTML(plugin));
                PluginsList.this.description.setCaretPosition(0);
            }
        }
    }
}

