/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.dashboard;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.io.FilenameUtils;
import org.apache.jmeter.report.core.DataContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateVisitor
extends SimpleFileVisitor<Path> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateVisitor.class);
    public static final String TEMPLATED_FILE_EXT = "fmkr";
    private final Path source;
    private final Path target;
    private final Configuration configuration;
    private final DataContext data;

    public TemplateVisitor(Path source, Path target, Configuration configuration, DataContext data) {
        this.source = source;
        this.target = target;
        this.configuration = configuration;
        this.data = data;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path file, BasicFileAttributes attrs) throws IOException {
        Path newDir = this.target.resolve(this.source.relativize(file));
        try {
            Files.copy(file, newDir, new CopyOption[0]);
        }
        catch (FileAlreadyExistsException ex) {
            LOGGER.info("Copying folder from '{}' to '{}', got message: {}, found non empty folder with following content {}, will be ignored", new Object[]{file, newDir, ex.getMessage(), newDir.toFile().listFiles()});
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        block39: {
            String extension = FilenameUtils.getExtension((String)file.toString());
            if (TEMPLATED_FILE_EXT.equalsIgnoreCase(extension)) {
                String templatePath = this.source.relativize(file).toString();
                Template template = this.configuration.getTemplate(templatePath);
                Path newPath = this.target.resolve(FilenameUtils.removeExtension((String)templatePath));
                try (FileOutputStream stream = new FileOutputStream(newPath.toString());
                     OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);
                     BufferedWriter bufferedWriter = new BufferedWriter(writer);){
                    template.process((Object)this.data, (Writer)bufferedWriter);
                    break block39;
                }
                catch (TemplateException ex) {
                    throw new IOException(ex);
                }
            }
            Path newFile = this.target.resolve(this.source.relativize(file));
            Files.copy(file, newFile, StandardCopyOption.REPLACE_EXISTING);
        }
        return FileVisitResult.CONTINUE;
    }
}

