/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.letsPlot;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import jetbrains.letsPlot.FrontendContext;
import jetbrains.letsPlot.frontend.DefaultSwingBatikFrontendContext;
import jetbrains.letsPlot.frontend.DefaultSwingJfxFrontendContext;
import jetbrains.letsPlot.frontend.NotebookFrontendContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0006\u0010\u0013\u001a\u00020\u0004J\b\u0010\u0014\u001a\u00020\u000bH\u0002J1\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\u0002\u0010\u001cR \u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Ljetbrains/letsPlot/LetsPlot;", "", "()V", "apiVersion", "", "getApiVersion$annotations", "getApiVersion", "()Ljava/lang/String;", "setApiVersion", "(Ljava/lang/String;)V", "frontendContext", "Ljetbrains/letsPlot/FrontendContext;", "getFrontendContext", "()Ljetbrains/letsPlot/FrontendContext;", "setFrontendContext", "(Ljetbrains/letsPlot/FrontendContext;)V", "getBooleanFromEnv", "", "name", "getInfo", "initDefaultFrontendContext", "setupNotebook", "Ljetbrains/letsPlot/frontend/NotebookFrontendContext;", "jsVersion", "isolatedFrame", "htmlRenderer", "Lkotlin/Function1;", "", "(Ljava/lang/String;Ljava/lang/Boolean;Lkotlin/jvm/functions/Function1;)Ljetbrains/letsPlot/frontend/NotebookFrontendContext;", "plot-api"})
public final class LetsPlot {
    @NotNull
    public static final LetsPlot INSTANCE = new LetsPlot();
    @NotNull
    private static FrontendContext frontendContext = INSTANCE.initDefaultFrontendContext();
    @NotNull
    private static String apiVersion = "Unknown";

    private LetsPlot() {
    }

    @NotNull
    public final FrontendContext getFrontendContext() {
        return frontendContext;
    }

    public final void setFrontendContext(@NotNull FrontendContext frontendContext) {
        Intrinsics.checkNotNullParameter((Object)frontendContext, (String)"<set-?>");
        LetsPlot.frontendContext = frontendContext;
    }

    @NotNull
    public final String getApiVersion() {
        return apiVersion;
    }

    public final void setApiVersion(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        apiVersion = string;
    }

    public static /* synthetic */ void getApiVersion$annotations() {
    }

    @NotNull
    public final String getInfo() {
        return "Lets-Plot Kotlin API v." + apiVersion + ". Frontend: " + frontendContext.getInfo();
    }

    @NotNull
    public final NotebookFrontendContext setupNotebook(@NotNull String jsVersion, @Nullable Boolean isolatedFrame, @NotNull Function1<? super String, Unit> htmlRenderer) {
        Intrinsics.checkNotNullParameter((Object)jsVersion, (String)"jsVersion");
        Intrinsics.checkNotNullParameter(htmlRenderer, (String)"htmlRenderer");
        Boolean bl = isolatedFrame;
        boolean isolatedFrameContext = bl == null ? this.getBooleanFromEnv("LETS_PLOT_HTML_ISOLATED_FRAME") : bl.booleanValue();
        frontendContext = new NotebookFrontendContext(jsVersion, isolatedFrameContext, htmlRenderer);
        return (NotebookFrontendContext)frontendContext;
    }

    private final boolean getBooleanFromEnv(String name) {
        boolean bl;
        String value = System.getenv(name);
        Object object = (Object[])value;
        boolean bl2 = false;
        boolean bl3 = false;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            bl = false;
        } else {
            object = new String[]{"true", "1", "t", "y", "yes"};
            List list = CollectionsKt.listOf((Object[])object);
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            object = value;
            bl2 = false;
            object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            bl3 = false;
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)object2).toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase(locale)");
            if (list.contains(string)) {
                bl = true;
            } else {
                object = new String[]{"false", "0", "f", "n", "no"};
                List list2 = CollectionsKt.listOf((Object[])object);
                object = value;
                boolean bl4 = false;
                object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
                bl3 = false;
                Object object3 = object;
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)object3).toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
                if (list2.contains(string2)) {
                    bl = false;
                } else {
                    throw new IllegalArgumentException("Can't convert str to boolean : [" + name + "] : " + value);
                }
            }
        }
        return bl;
    }

    private final FrontendContext initDefaultFrontendContext() {
        FrontendContext frontendContext;
        FrontendContext frontendContext2 = DefaultSwingBatikFrontendContext.Companion.tryCreate();
        return frontendContext2 == null ? ((frontendContext = DefaultSwingJfxFrontendContext.Companion.tryCreate()) == null ? (FrontendContext)new FrontendContext(){

            public void display(@NotNull Map<String, Object> plotSpecRaw) {
                Intrinsics.checkNotNullParameter(plotSpecRaw, (String)"plotSpecRaw");
                throw new IllegalStateException("\nThe frontend context is not defined.\nTo define the frontend context please select one of the following options:\na. Add \"lets-plot-batik-<version>.jar\" to your classpath.   \nb. Add \"lets-plot-jfx-<version>.jar\" to your classpath.   \nc. Specify the frontend context explicitly: \"LetsPlot.frontendContext = ...\"\n   ");
            }

            @NotNull
            public String getInfo() {
                return FrontendContext.DefaultImpls.getInfo(this);
            }
        } : frontendContext) : frontendContext2;
    }
}

