/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.vis.swing;

import java.awt.Dimension;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.MonolithicAwt;
import jetbrains.datalore.plot.PlotSizeHelper;
import jetbrains.datalore.plot.config.PlotConfig;
import jetbrains.datalore.plot.config.PlotConfigClientSide;
import jetbrains.datalore.vis.svg.SvgSvgElement;
import jetbrains.datalore.vis.swing.PlotComponentProvider;
import jetbrains.datalore.vis.swing.PlotSpecComponentProvider;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cBx\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\t\u0012\u0018\u0010\u000f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0004\u0012\u00020\u00110\t\u0012\u0018\u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0013\u0012\u0004\u0012\u00020\u00110\t\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000eH$J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R \u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0013\u0012\u0004\u0012\u00020\u00110\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0004\u0012\u00020\u00110\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ljetbrains/datalore/vis/swing/PlotSpecComponentProvider;", "Ljetbrains/datalore/vis/swing/PlotComponentProvider;", "processedSpec", "", "", "", "preserveAspectRatio", "", "svgComponentFactory", "Lkotlin/Function1;", "Ljetbrains/datalore/vis/svg/SvgSvgElement;", "Lkotlin/ParameterName;", "name", "svg", "Ljavax/swing/JComponent;", "executor", "Lkotlin/Function0;", "", "computationMessagesHandler", "", "(Ljava/util/Map;ZLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "createComponent", "containerSize", "Ljava/awt/Dimension;", "createScrollPane", "Ljavax/swing/JScrollPane;", "plotComponent", "getPreferredSize", "Companion", "vis-swing-common"})
public abstract class PlotSpecComponentProvider
implements PlotComponentProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Object> processedSpec;
    private final boolean preserveAspectRatio;
    @NotNull
    private final Function1<SvgSvgElement, JComponent> svgComponentFactory;
    @NotNull
    private final Function1<Function0<Unit>, Unit> executor;
    @NotNull
    private final Function1<List<String>, Unit> computationMessagesHandler;

    public PlotSpecComponentProvider(@NotNull Map<String, Object> processedSpec, boolean preserveAspectRatio, @NotNull Function1<? super SvgSvgElement, ? extends JComponent> svgComponentFactory, @NotNull Function1<? super Function0<Unit>, Unit> executor, @NotNull Function1<? super List<String>, Unit> computationMessagesHandler) {
        Intrinsics.checkNotNullParameter(processedSpec, (String)"processedSpec");
        Intrinsics.checkNotNullParameter(svgComponentFactory, (String)"svgComponentFactory");
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        Intrinsics.checkNotNullParameter(computationMessagesHandler, (String)"computationMessagesHandler");
        this.processedSpec = processedSpec;
        this.preserveAspectRatio = preserveAspectRatio;
        this.svgComponentFactory = svgComponentFactory;
        this.executor = executor;
        this.computationMessagesHandler = computationMessagesHandler;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize(@NotNull Dimension containerSize) {
        Intrinsics.checkNotNullParameter((Object)containerSize, (String)"containerSize");
        return PlotSpecComponentProvider.Companion.preferredFigureSize(this.processedSpec, this.preserveAspectRatio, containerSize);
    }

    @Override
    @NotNull
    public JComponent createComponent(@Nullable Dimension containerSize) {
        JComponent jComponent;
        DoubleVector doubleVector;
        Dimension dimension = containerSize;
        if (dimension == null) {
            doubleVector = null;
        } else {
            Dimension dimension2 = dimension;
            boolean bl = false;
            boolean bl2 = false;
            Dimension it = dimension2;
            boolean bl3 = false;
            Dimension preferredSize = this.getPreferredSize(containerSize);
            doubleVector = new DoubleVector((double)preferredSize.width, (double)preferredSize.height);
        }
        DoubleVector plotSize = doubleVector;
        JComponent plotComponent = PlotSpecComponentProvider.Companion.createPlotComponent(this.processedSpec, plotSize, (Function1<? super SvgSvgElement, ? extends JComponent>)this.svgComponentFactory, (Function1<? super Function0<Unit>, Unit>)this.executor, (Function1<? super List<String>, Unit>)this.computationMessagesHandler);
        if (PlotConfig.Companion.isGGBunchSpec(this.processedSpec)) {
            JScrollPane scrollPane = this.createScrollPane(plotComponent);
            Dimension dimension3 = containerSize;
            if (dimension3 != null) {
                Dimension dimension4 = dimension3;
                boolean bl = false;
                boolean bl4 = false;
                Dimension $this$createComponent_u24lambda_u2d1 = dimension4;
                boolean bl5 = false;
                scrollPane.setPreferredSize(containerSize);
                scrollPane.setSize(containerSize);
            }
            jComponent = scrollPane;
        } else {
            jComponent = plotComponent;
        }
        return jComponent;
    }

    @NotNull
    protected abstract JScrollPane createScrollPane(@NotNull JComponent var1);

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J}\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2!\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00040\u000b2\u0018\u0010\u0010\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0004\u0012\u00020\u00120\u000b2\u0018\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0014\u0012\u0004\u0012\u00020\u00120\u000bH\u0002J,\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016H\u0002\u00a8\u0006\u001c"}, d2={"Ljetbrains/datalore/vis/swing/PlotSpecComponentProvider$Companion;", "", "()V", "createPlotComponent", "Ljavax/swing/JComponent;", "figureSpecProcessed", "", "", "preferredSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "svgComponentFactory", "Lkotlin/Function1;", "Ljetbrains/datalore/vis/svg/SvgSvgElement;", "Lkotlin/ParameterName;", "name", "svg", "executor", "Lkotlin/Function0;", "", "computationMessagesHandler", "", "preferredFigureSize", "Ljava/awt/Dimension;", "figureSpec", "", "preserveAspectRatio", "", "containerSize", "vis-swing-common"})
    public static final class Companion {
        private Companion() {
        }

        private final JComponent createPlotComponent(Map<String, Object> figureSpecProcessed, DoubleVector preferredSize, Function1<? super SvgSvgElement, ? extends JComponent> svgComponentFactory, Function1<? super Function0<Unit>, Unit> executor, Function1<? super List<String>, Unit> computationMessagesHandler) {
            return MonolithicAwt.INSTANCE.buildPlotFromProcessedSpecs(figureSpecProcessed, preferredSize, null, svgComponentFactory, executor, computationMessagesHandler);
        }

        private final Dimension preferredFigureSize(Map<String, ? extends Object> figureSpec, boolean preserveAspectRatio, Dimension containerSize) {
            Dimension dimension;
            int width = containerSize.width;
            int height = containerSize.height;
            if (PlotConfig.Companion.isGGBunchSpec(figureSpec)) {
                DoubleVector bunchSize = PlotSizeHelper.INSTANCE.plotBunchSize(figureSpec);
                double d = bunchSize.getX();
                boolean bl = false;
                int n = (int)Math.ceil(d);
                d = bunchSize.getY();
                bl = false;
                Dimension dimension2 = new Dimension(n, (int)Math.ceil(d));
                dimension = dimension2;
            } else if (PlotConfig.Companion.isPlotSpec(figureSpec)) {
                if (!preserveAspectRatio) {
                    return containerSize;
                }
                PlotConfigClientSide config2 = PlotConfigClientSide.Companion.create(figureSpec, (Function1)preferredFigureSize.config.1.INSTANCE);
                DoubleVector defaultSize = PlotSizeHelper.INSTANCE.singlePlotSize(figureSpec, null, null, config2.getFacets(), config2.getContainsLiveMap());
                double aspectRatio = defaultSize.getX() / defaultSize.getY();
                if (aspectRatio >= 1.0) {
                    double plotHeight = (double)width / aspectRatio;
                    double scaling = plotHeight > (double)height ? (double)height / plotHeight : 1.0;
                    double d = (double)width * scaling;
                    boolean bl = false;
                    int n = (int)Math.floor(d);
                    d = plotHeight * scaling;
                    bl = false;
                    Dimension dimension3 = new Dimension(n, (int)Math.floor(d));
                    dimension = dimension3;
                } else {
                    double plotWidth = (double)height * aspectRatio;
                    double scaling = plotWidth > (double)width ? (double)width / plotWidth : 1.0;
                    double d = plotWidth * scaling;
                    boolean bl = false;
                    int n = (int)Math.floor(d);
                    d = (double)height * scaling;
                    bl = false;
                    Dimension dimension4 = new Dimension(n, (int)Math.floor(d));
                    dimension = dimension4;
                }
            } else {
                dimension = new Dimension(width, height);
            }
            return dimension;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

