/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder;

import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.registration.CompositeRegistration;
import jetbrains.datalore.base.registration.Registration;
import jetbrains.datalore.base.values.SomeFig;
import jetbrains.datalore.plot.builder.PlotSvgComponent;
import jetbrains.datalore.plot.builder.presentation.Style;
import jetbrains.datalore.vis.svg.SvgCssResource;
import jetbrains.datalore.vis.svg.SvgSvgElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0006\u0010\u001b\u001a\u00020\u0019J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0004J\u000e\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u0005J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0005H\u0002R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\""}, d2={"Ljetbrains/datalore/plot/builder/PlotContainerPortable;", "", "plot", "Ljetbrains/datalore/plot/builder/PlotSvgComponent;", "plotSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "(Ljetbrains/datalore/plot/builder/PlotSvgComponent;Ljetbrains/datalore/base/geometry/DoubleVector;)V", "isLiveMap", "", "()Z", "liveMapFigures", "", "Ljetbrains/datalore/base/values/SomeFig;", "getLiveMapFigures", "()Ljava/util/List;", "myContentBuilt", "myRegistrations", "Ljetbrains/datalore/base/registration/CompositeRegistration;", "getPlot", "()Ljetbrains/datalore/plot/builder/PlotSvgComponent;", "svg", "Ljetbrains/datalore/vis/svg/SvgSvgElement;", "getSvg", "()Ljetbrains/datalore/vis/svg/SvgSvgElement;", "buildContent", "", "clearContent", "ensureContentBuilt", "reg", "registration", "Ljetbrains/datalore/base/registration/Registration;", "resize", "setSvgSize", "size", "plot-builder-portable"})
public class PlotContainerPortable {
    @NotNull
    private final PlotSvgComponent plot;
    @NotNull
    private final SvgSvgElement svg;
    private boolean myContentBuilt;
    @NotNull
    private CompositeRegistration myRegistrations;

    public PlotContainerPortable(@NotNull PlotSvgComponent plot, @NotNull DoubleVector plotSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)plot), (String)"plot");
        Intrinsics.checkNotNullParameter((Object)plotSize, (String)"plotSize");
        this.plot = plot;
        this.svg = new SvgSvgElement();
        this.myRegistrations = new CompositeRegistration(new Registration[0]);
        this.svg.addClass("plt-container");
        this.setSvgSize(plotSize);
        this.plot.resize(plotSize);
    }

    @NotNull
    protected final PlotSvgComponent getPlot() {
        return this.plot;
    }

    @NotNull
    public final SvgSvgElement getSvg() {
        return this.svg;
    }

    @NotNull
    public final List<SomeFig> getLiveMapFigures() {
        return this.plot.getLiveMapFigures$plot_builder_portable();
    }

    public final boolean isLiveMap() {
        Collection collection = this.plot.getLiveMapFigures$plot_builder_portable();
        boolean bl = false;
        return !collection.isEmpty();
    }

    public final void ensureContentBuilt() {
        if (!this.myContentBuilt) {
            this.buildContent();
        }
    }

    public final void resize(@NotNull DoubleVector plotSize) {
        Intrinsics.checkNotNullParameter((Object)plotSize, (String)"plotSize");
        if (plotSize.getX() <= 0.0 || plotSize.getY() <= 0.0) {
            return;
        }
        if (Intrinsics.areEqual((Object)plotSize, (Object)this.plot.getPlotSize())) {
            return;
        }
        this.clearContent();
        this.setSvgSize(plotSize);
        this.plot.resize(plotSize);
    }

    protected void buildContent() {
        boolean bl = !this.myContentBuilt;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.myContentBuilt = true;
        this.svg.setStyle(new SvgCssResource(){

            @NotNull
            public String css() {
                return Style.INSTANCE.getCss();
            }
        });
        this.svg.children().add((Object)this.plot.getRootGroup());
    }

    public void clearContent() {
        if (this.myContentBuilt) {
            this.myContentBuilt = false;
            this.svg.children().clear();
            this.plot.clear();
            this.myRegistrations.remove();
            this.myRegistrations = new CompositeRegistration(new Registration[0]);
        }
    }

    protected final void reg(@NotNull Registration registration2) {
        Intrinsics.checkNotNullParameter((Object)registration2, (String)"registration");
        this.myRegistrations.add(registration2);
    }

    private final void setSvgSize(DoubleVector size) {
        this.svg.width().set((Object)size.getX());
        this.svg.height().set((Object)size.getY());
    }
}

